/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.fabric.block;

import java.util.Objects;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.Nullable;
import owmii.powah.block.Tier;
import owmii.powah.block.cable.CableTile;
import team.reborn.energy.api.EnergyStorage;

public class FabricCableTile
extends CableTile {
    private int lastBump = 0;

    public FabricCableTile(class_2338 pos, class_2680 state, Tier variant) {
        super(pos, state, variant);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long insert(long maxReceive, TransactionContext transaction, @Nullable class_2350 direction) {
        if (this.field_11863 == null || this.isRemote() || direction == null || !this.checkRedstone() || !this.canReceiveEnergy(direction)) {
            return 0L;
        }
        long received = 0L;
        Iterable<CableTile> cables = this.getCables();
        MutableBoolean insertionGuard = this.netInsertionGuard;
        if (insertionGuard.isTrue()) {
            return 0L;
        }
        insertionGuard.setTrue();
        try {
            int tickCount = ((class_3218)this.method_10997()).method_8503().method_3780();
            if (this.lastBump != tickCount) {
                this.lastBump = tickCount;
                ++this.startIndex;
            }
            for (CableTile cable : cables) {
                long amount = maxReceive - received;
                if (amount <= 0L) break;
                if (cable.energySides.isEmpty() || !cable.isActive()) continue;
                received += ((FabricCableTile)cable).pushEnergy(amount, transaction, direction, this);
            }
            long l = received;
            return l;
        }
        finally {
            insertionGuard.setFalse();
        }
    }

    private long pushEnergy(long maxReceive, TransactionContext transaction, @Nullable class_2350 direction, CableTile cable) {
        class_1937 class_19372 = this.method_10997();
        if (!(class_19372 instanceof class_3218)) {
            throw new RuntimeException("Expected server level");
        }
        class_3218 serverLevel = (class_3218)class_19372;
        long received = 0L;
        for (int i = 0; i < 6; ++i) {
            class_2350 side = class_2350.method_10143((int)((i + serverLevel.method_8503().method_3780()) % 6));
            if (!this.energySides.contains(side)) continue;
            long amount = Math.min(maxReceive - received, this.energy.getMaxExtract());
            if (amount <= 0L) break;
            if (cable.equals(this) && side.equals((Object)direction) || !this.canExtractEnergy(side)) continue;
            class_2338 pos = this.field_11867.method_10093(side);
            if (direction != null && cable.method_11016().method_10093(direction).equals((Object)pos)) continue;
            received += this.receive(this.field_11863, pos, side.method_10153(), amount, transaction);
        }
        return received;
    }

    private long receive(class_1937 level, class_2338 pos, class_2350 side, long amount, TransactionContext transaction) {
        return Objects.requireNonNullElse((EnergyStorage)EnergyStorage.SIDED.find(level, pos, (Object)side), EnergyStorage.EMPTY).insert(amount, transaction);
    }
}

